

export class ObjectPermissionWidget {
	
	tpl = `
	<div class="permissions-edit-container">
		<div class="action-box">
			<span ez-if="writable">
				<a class="btn-link-user-group" href="javascript:void(0);" [onclick]="widget.addPermissionRecord">Gebruiker/groep toevoegen</a>
			</span>
		</div>
		
		<br/>

		<table class="table">
			<thead>
				<tr>
					<th>Gebruiker</th>
					<th>Permissies</th>
					<th></th>
				</tr>
			</thead>
			
			<tbody id="tbody-permissions">
				
				<tr class="no-results-found">
					<td colspan="100%">{{_('No results found')}}</td>
				</tr>
			</tbody>
		</table>
		
		
		<br/><br/>
		
		<h2>{{_('Inherited permissions')}}</h2>
		<table class="table">
			<thead>
				<tr>
					<th>Gebruiker / Groep</th>
					<th>Rechten</th>
					<th>Afkomst</th>
				</tr>
			</thead>
			<tbody ez-for="inheritedPermissions" ez-item="ip">
				<tr>
					<td>{{ip.textValue}}</td>
					<td>{{_('accessMethod.'+ip.accessMethod)}}</td>
					<td>
						{{ ip.permissionNote }}
					</td>
				</tr>
			</tbody>
			<tbody class="no-results-found">
				<tr ez-if="inheritedPermissions.length == 0">
					<td colspan="100%">
						{{_('No results found')}}
					</td>
				</tr>
			</tbody>
		</table>
		
	</div>
		
	`;
	
	container = null;
	writable = false;
	
	accessMethod = null;
	userPermissionList = null;
	
	input_counter = 0;
	
	constructor() {
		
	}
	
	init(e) {
		
		this.container = e;
		
	}
	
	
	
	setAccessMethod(m) {
		this.accessMethod = m;
		
		if (m == 'write')
			this.writable = true
		else
			this.writable = false;
	}
	setUserPermissionList( upl ) { this.userPermissionList = upl; }
	
	
	getPermissions() {
		let permissions = [];
		
		$(this.container).find('#tbody-permissions tr').each(function(index, node) {
			if ($(node).hasClass('no-results-found'))
				return;
			
			// user- or group- selected?
			let userOrGroupId = $(node).find('input.widget-value').val();
			if (userOrGroupId == '')
				return;
			
			let accessMethod = 'read';
			if ( $(node).find('.perm-write [value=write]').prop('checked') )
				accessMethod = 'write';
			
			
			permissions.push({
				userGroupId: userOrGroupId,
				accessMethod: accessMethod
			})
		});
		
		return permissions;
	}
	
	
	render() {
		let ezTpl = new EzTemplate( this.container );
		ezTpl.loadHtml( this.tpl );
		ezTpl.setObject( 'widget', this );
		ezTpl.setVar('writable', this.writable);

		ezTpl.setVar('inheritedPermissions', []);
		if (this.userPermissionList && this.userPermissionList.inheritedPermissions) {
			ezTpl.setVar('inheritedPermissions', this.userPermissionList.inheritedPermissions);
		}
		
		ezTpl.render();
		
		
		if (this.userPermissionList && this.userPermissionList.permissions) {
			let perms = this.userPermissionList.permissions;
			for(let i=0; i < perms.length; i++) {
				this.createPermissionRecord( perms[i] );
			}
		}
		
		
	}
	
	
	addPermissionRecord( ) {
		this.createPermissionRecord();
	}

	
	
	createPermissionRecord( opts ) {
		opts = opts ? opts : {};
		
		
		let no = ++this.input_counter;
		
		let tr = document.createElement('tr');
		
		let tduser        = document.createElement('td');
		
		let tdpermissions = document.createElement('td');
		tdpermissions.className = 'td-permissions';
		
		
		let inp_read = document.createElement('input');
		inp_read.type = 'radio';
		inp_read.name = 'perm_access_'+no;
		inp_read.value = 'read';
		inp_read.checked = true;
		if (this.writable == false)
			inp_read.setAttribute('disabled', 'disabled');
		
		let lbl_read = document.createElement('label');
		lbl_read.className = 'perm-read';
		lbl_read.append( inp_read );
		lbl_read.append( ' lezen ' );
		
		tdpermissions.append( lbl_read );
		
		
		
		let inp_write = document.createElement('input');
		inp_write.type = 'radio';
		inp_write.value = 'write';
		inp_write.name = 'perm_access_'+no;
		if (this.writable == false)
				inp_write.setAttribute('disabled', 'disabled');
		
		let lbl_write = document.createElement('label');
		lbl_write.className = 'perm-write';
		lbl_write.append(inp_write);
		lbl_write.append( ' schrijven ');
		tdpermissions.append( lbl_write );
		
		if (opts && opts.accessMethod == 'read') {
			inp_read.checked = true;
			inp_write.checked = false;
		}
		if (opts && opts.accessMethod == 'write') {
			inp_read.checked = false;
			inp_write.checked = true;
		}
		
		
		// del
		let tdactions     = document.createElement('td');
		tdactions.className = 'actions';
		
		if (this.writable) {
			let a_del = document.createElement('a');
			a_del.className = 'fa fa-trash';
			a_del.href = 'javascript:void(0);';
			a_del.onclick = function() {
				$(this).closest('tr').remove();
			};
			tdactions.append( a_del );
		}
		
		
		
		tr.append( tduser );
		tr.append( tdpermissions );
		tr.append( tdactions );
		
		let tbody_permissions = $(this.container).find( '#tbody-permissions' ).get(0);
		console.log('tbody_per', tbody_permissions);
		tbody_permissions.append( tr );
		
		if (this.writable) {
			let d = document.createElement('div');
			d.className = 'ez-table-container';
			tduser.append(d);
			
			
			let eztbl = new EzTableSelector( d );
			eztbl.setName( 'perm_ug_'+no );
			
			if (opts && opts.refUserGroupId ) {
				eztbl.setValueText( opts.refUserGroupId, opts.textValue );
			}
			eztbl.setUrl( appUrl('/service/users.do?a=listUserGroups') );
			eztbl.init();
		}
		else {
			let span_username = document.createElement('span');
			span_username.innerText = opts.textValue;
			tduser.append( span_username );
		}
	}
	
	
}
